//------------------------------------------------------------------------------
// File: client_cmdstatetracker.cs
// This file contains the CmdStateTracker script methods
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Updates object selection in the command system state tracker (needed for
//! state transition and state machine)
////////////////////////////////////////////////////////////////////////////////
function CmdStateTracker::updateSelection(%this)
{
   // Store selected objects
   %this.setSelection(gSelection.getSelectedGroup($SELECT_ID));
}

////////////////////////////////////////////////////////////////////////////////
//! Tries to get a target with the current view direction and mouse location.
////////////////////////////////////////////////////////////////////////////////
function CmdStateTracker::updateTarget(%this)
{
   // Get possible targets
   %objsHit = CmdInterpreter.interpretTarget();
   
   // No targets
   if(%objsHit.getSize() == 0)
      return;
   %target = %objsHit.getID(0);
   if(!isObject(%target))
      return;
   
   // Store location
   if(slgIsTerrain(%target)) {
      %this.setLocTarget(PlayGui.getPointRollover());
   }
   // Store object
   else {
      %this.setObjTarget(%target);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Tries to get a target and command with the current view direction and mouse
//! location.
////////////////////////////////////////////////////////////////////////////////
function CmdStateTracker::updateTargetAndCmd(%this)
{
   // Get possible targets
   %objsHit = CmdInterpreter.interpretTarget();
   
   // No targets
   if(%objsHit.getSize() == 0)
      return;
   %target = %objsHit.getID(0);
   if(!isObject(%target))
      return;

   // check if the target is bridge that was started from the
   // last link object instead of the first (bridge target
   // may need to change)
   if (%target.isMemberofClass("SLGameObj") == true &&
      %target.isLinkObj() == true)
   {
      // get the first building link object (either the first or
      // last depending on the start link)
      %desired = %target.getFirstLinkObj();
      if (%desired.linkStart == false)
      {
         %desired = %desired.getLastLinkObj();
         if (isObject(%desired) == false)
         {
            return;
         }
      }
      
      // get the building component for the start link
      %building = slgQueryInterface(%desired, $CID_BUILDING);
      if (isObject(%building) == false)
      {
         return;
      }
      
      // if the start link object is not in the production state,
      // use the start link instead of the original target
      if (%building.getState() != $BuildingState::Production)
      {
         %target = %desired;
      }
   }
   
   // Get Command
   %selObjs = gSelection.getSelectedGroup($SELECT_ID);
   %cmd     = CmdInterpreter.interpretCommand(%target, %selObjs);

   // Invalid command
   if(!CmdInterpreter.isValidCommand(%cmd))
      return;
   
   // Store command and target
   %this.setCommand(%cmd);
   
   // Store location
   if(slgIsTerrain(%target)) {
      %this.setLocTarget(PlayGui.getPointRollover());
   }
   // Store object
   else {
      %this.setObjTarget(%target);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Sends a command message to the server with the current target and command
////////////////////////////////////////////////////////////////////////////////
function CmdStateTracker::sendCmdMsg(%this)
{
   %this.sendCmdRequest();
}

// End client_cmdstatetracker.cs